/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.reflect;

import de.eztxm.ezlib.config.annotation.JsonConfig;
import de.eztxm.ezlib.config.mapper.JsonMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;

public class JsonProcessor<T> {
    private final T instance;
    private final Path file;

    public JsonProcessor(T instance) {
        this.instance = instance;
        Class<?> clazz = instance.getClass();
        if (!clazz.isAnnotationPresent(JsonConfig.class)) {
            throw new IllegalStateException("Klasse " + clazz.getName() + " hat keine JsonClassConfig-Annotation!");
        }
        JsonConfig annotation = clazz.getAnnotation(JsonConfig.class);
        this.file = Paths.get(annotation.path(), annotation.fileName());
    }

    public void saveConfiguration() {
        try {
            if (Files.notExists(this.file.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            }
            Files.writeString(this.file, (CharSequence)JsonMapper.toJson(this.instance), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Speichern der Konfiguration: " + e.getMessage(), e);
        }
    }

    public static <T> JsonProcessor<T> loadConfiguration(Class<T> clazz) {
        T instance;
        if (!clazz.isAnnotationPresent(JsonConfig.class)) {
            throw new IllegalStateException("Klasse " + clazz.getName() + " hat keine JsonClassConfig-Annotation!");
        }
        JsonConfig annotation = clazz.getAnnotation(JsonConfig.class);
        Path file = Paths.get(annotation.path(), annotation.fileName());
        try {
            if (Files.exists(file, new LinkOption[0]) && Files.size(file) > 0L) {
                String raw = Files.readString(file);
                instance = JsonMapper.fromJson(raw, clazz);
            } else {
                instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fehler beim Laden der Konfiguration: " + e.getMessage(), e);
        }
        return new JsonProcessor<T>(instance);
    }

    @Generated
    public T getInstance() {
        return this.instance;
    }

    @Generated
    public Path getFile() {
        return this.file;
    }
}

