/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.object;

import de.eztxm.ezlib.config.object.JsonObject;
import de.eztxm.ezlib.config.object.JsonUtil;
import de.eztxm.ezlib.config.object.JsonValue;
import de.eztxm.ezlib.config.object.ObjectConverter;
import de.eztxm.ezlib.config.parse.JsonParser;
import java.util.ArrayList;

public class JsonArray<T>
extends ArrayList<T>
implements JsonValue {
    public ObjectConverter get(String key) {
        for (Object type : this) {
            JsonObject jsonObject;
            if (!(type instanceof JsonObject) || !(jsonObject = (JsonObject)type).containsKey(key)) continue;
            return new ObjectConverter(jsonObject.get(key));
        }
        return null;
    }

    @Override
    public String toJsonString() {
        StringBuilder sb = new StringBuilder();
        boolean pretty = JsonUtil.prettyPrint;
        sb.append("[");
        if (pretty) {
            sb.append("\n");
        }
        boolean first = true;
        for (Object value : this) {
            if (!first) {
                sb.append(pretty ? ",\n" : ",");
            }
            if (pretty) {
                sb.append(JsonUtil.indent(4));
            }
            sb.append(JsonUtil.valueToJson(value));
            first = false;
        }
        if (pretty) {
            sb.append("\n").append(JsonUtil.indent(4));
        }
        sb.append("]");
        return sb.toString();
    }

    public Class<?> getElementType() {
        Object type = null;
        for (Object item : this) {
            if (item == null) continue;
            if (type == null) {
                return item.getClass();
            }
            return Object.class;
        }
        return Object.class;
    }

    public static <T> JsonArray<T> parse(String json, Class<T> clazz) {
        JsonParser parser = new JsonParser();
        Object result = parser.parse(json);
        if (!(result instanceof JsonArray)) {
            throw new IllegalArgumentException("JSON is not an array");
        }
        JsonArray rawArray = (JsonArray)result;
        JsonArray<T> typedArray = new JsonArray<T>();
        for (Object element : rawArray) {
            if (clazz.isInstance(element)) {
                typedArray.add(clazz.cast(element));
                continue;
            }
            throw new IllegalArgumentException("Element type mismatch: expected " + String.valueOf(clazz) + " but got " + String.valueOf(element.getClass()));
        }
        return typedArray;
    }
}

