/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.dsm.common.server.container;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import java.io.Closeable;
import java.io.File;
import java.util.UUID;
import org.json.JSONObject;

public class ServerContainer
extends Thread {
    private final String prefix;
    private final DockerClient dockerClient;
    private final String basePath;
    private String platform;
    private String version;
    private String containerId;
    private UUID uniqueId;
    private String serverPath;
    private int port;
    private int memory;

    public ServerContainer(String prefix, DockerClient dockerClient, String basePath, String platform, String version, int port, int memory) {
        this.prefix = prefix;
        this.dockerClient = dockerClient;
        this.basePath = basePath;
        this.platform = platform;
        this.version = version;
        this.port = port;
        this.memory = memory;
    }

    public ServerContainer(String prefix, DockerClient dockerClient, String basePath, String containerId, String uniqueId) {
        this.prefix = prefix;
        this.dockerClient = dockerClient;
        this.basePath = basePath;
        this.containerId = containerId;
        this.uniqueId = UUID.fromString(uniqueId);
        this.serverPath = this.basePath + "/" + String.valueOf(this.uniqueId) + "/server";
    }

    @Override
    public void run() {
    }

    public String createAndStartContainer() {
        this.uniqueId = UUID.randomUUID();
        this.serverPath = this.basePath + "/" + String.valueOf(this.uniqueId) + "/server";
        String imageName = "itzg/minecraft-server";
        String containerName = this.prefix + "-" + String.valueOf(this.uniqueId);
        File serverDir = new File(this.serverPath);
        this.createServerDirectory(serverDir);
        Volume serverVolume = new Volume("/data");
        ExposedPort containerPort = ExposedPort.tcp((int)25565);
        Ports portBindings = new Ports();
        portBindings.bind(containerPort, Ports.Binding.bindPort((int)this.port));
        CreateContainerResponse container = this.dockerClient.createContainerCmd(imageName).withName(containerName).withHostConfig(HostConfig.newHostConfig().withBinds(new Bind[]{new Bind(this.serverPath, serverVolume)}).withPortBindings(portBindings).withRestartPolicy(RestartPolicy.alwaysRestart())).withEnv(new String[]{"EULA=TRUE", "TYPE=" + this.platform.toUpperCase(), "VERSION=" + this.version, "MEMORY=" + this.memory + "M"}).exec();
        this.containerId = container.getId();
        System.out.println(this.containerId);
        this.dockerClient.startContainerCmd(this.containerId).exec();
        this.printContainerLogs();
        JSONObject serverInfoObject = new JSONObject();
        serverInfoObject.put("containerName", (Object)containerName);
        serverInfoObject.put("containerId", (Object)this.containerId);
        serverInfoObject.put("path", (Object)this.serverPath);
        serverInfoObject.put("port", this.port);
        String[] command = new String[]{"sh", "-c", "echo '" + String.valueOf(serverInfoObject) + "' > /data/server-info.json"};
        try {
            ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(this.containerId).withCmd(command).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).exec();
            ExecStartCmd execStartCmd = this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true));
            execStartCmd.exec((ResultCallback)new ResultCallback<Frame>(){

                public void onStart(Closeable closeable) {
                }

                public void onComplete() {
                }

                public void onError(Throwable throwable) {
                }

                public void onNext(Frame frame) {
                }

                public void close() {
                }
            });
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return "/" + containerName;
    }

    public String recreateAndStartContainerFromDirectory(String uniqueId) {
        this.uniqueId = UUID.fromString(uniqueId);
        this.serverPath = this.basePath + "/" + String.valueOf(this.uniqueId) + "/server";
        String containerName = this.prefix + "-" + String.valueOf(this.uniqueId);
        File serverDir = new File(this.serverPath);
        this.createServerDirectory(serverDir);
        Volume serverVolume = new Volume("/data");
        ExposedPort containerPort = ExposedPort.tcp((int)25565);
        Ports portBindings = new Ports();
        portBindings.bind(containerPort, Ports.Binding.bindPort((int)this.port));
        CreateContainerResponse container = this.dockerClient.createContainerCmd("itzg/minecraft-server").withName(containerName).withHostConfig(HostConfig.newHostConfig().withBinds(new Bind[]{new Bind(this.serverPath, serverVolume)}).withPortBindings(portBindings).withRestartPolicy(RestartPolicy.alwaysRestart())).withEnv(new String[]{"EULA=TRUE", "TYPE=" + this.platform.toUpperCase(), "VERSION=" + this.version, "MEMORY=" + this.memory + "M"}).exec();
        this.containerId = container.getId();
        this.dockerClient.startContainerCmd(this.containerId).exec();
        this.printContainerLogs();
        return "/" + containerName;
    }

    public void printContainerLogs() {
        try {
            (this.dockerClient.logContainerCmd(this.containerId).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){

                public void onNext(Frame frame) {
                }
            })).awaitCompletion();
        }
        catch (InterruptedException e) {
            System.err.println("Fehler beim Abrufen der Logs: " + e.getMessage());
        }
    }

    public void startContainer() {
        if (this.containerId == null) {
            return;
        }
        try {
            this.dockerClient.startContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException notModifiedException) {
            // empty catch block
        }
    }

    public void restartContainer() {
        if (this.containerId == null) {
            return;
        }
        try {
            this.dockerClient.restartContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException notModifiedException) {
            // empty catch block
        }
    }

    public void stopContainer() {
        if (this.containerId == null) {
            return;
        }
        try {
            this.dockerClient.stopContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException notModifiedException) {
            // empty catch block
        }
    }

    public void removeContainer() {
        if (this.containerId == null) {
            return;
        }
        try {
            this.dockerClient.stopContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException notModifiedException) {
            // empty catch block
        }
        try {
            this.dockerClient.removeContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException notModifiedException) {
            // empty catch block
        }
    }

    private void createServerDirectory(File serverDir) {
        if (!serverDir.exists()) {
            serverDir.mkdirs();
        }
    }

    public String getServerPath() {
        return this.serverPath;
    }
}

