/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.nexonet.client;

import com.nexoscript.nexonet.api.events.client.ClientConnectEvent;
import com.nexoscript.nexonet.api.events.client.ClientDisconnectEvent;
import com.nexoscript.nexonet.api.events.client.ClientReceivedEvent;
import com.nexoscript.nexonet.api.events.client.ClientSendEvent;
import com.nexoscript.nexonet.api.networking.IClient;
import com.nexoscript.nexonet.api.packet.IPacketManager;
import com.nexoscript.nexonet.api.packet.Packet;
import com.nexoscript.nexonet.logger.LoggingType;
import com.nexoscript.nexonet.logger.NexonetLogger;
import com.nexoscript.nexonet.packet.PacketManager;
import com.nexoscript.nexonet.packet.impl.AuthPacket;
import com.nexoscript.nexonet.packet.impl.AuthResponsePacket;
import com.nexoscript.nexonet.packet.impl.DisconnectPacket;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.UUID;

public class Client
implements IClient {
    private boolean isAuth;
    private boolean logging;
    private NexonetLogger logger;
    private String id;
    private boolean isRunning = false;
    private Socket socket;
    private BufferedReader reader;
    private PrintWriter writer;
    private String hostname;
    private int port;
    private ClientConnectEvent clientConnectEvent;
    private ClientDisconnectEvent clientDisconnectEvent;
    private ClientReceivedEvent clientReceivedEvent;
    private ClientSendEvent clientSendEvent;
    private IPacketManager packetManager;

    public Client(boolean logging) {
        this.logging = logging;
        this.logger = new NexonetLogger(logging);
        this.packetManager = new PacketManager(this.logger);
        this.initialize();
    }

    public Client() {
        this.logging = false;
        this.logger = new NexonetLogger(false);
        this.packetManager = new PacketManager();
        this.initialize();
    }

    private void initialize() {
        this.packetManager.registerPacketType("AUTH", AuthPacket.class);
        this.packetManager.registerPacketType("AUTH_RESPONSE", AuthResponsePacket.class);
        this.packetManager.registerPacketType("DISCONNECT", DisconnectPacket.class);
        this.clientConnectEvent = client -> {};
        this.clientDisconnectEvent = client -> {};
        this.clientReceivedEvent = (client, packet) -> {};
        this.clientSendEvent = (client, packet) -> {};
    }

    public void connect(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.logger.log(LoggingType.INFO, "Connecting to server...");
        try {
            this.socket = new Socket(this.hostname, this.port);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintWriter(this.socket.getOutputStream(), true);
            Runtime.getRuntime().addShutdownHook(new Thread(this::disconnect));
            this.logger.log(LoggingType.INFO, "Connected to server");
            this.isRunning = true;
            while (this.isRunning) {
                Object serverResponse;
                if (!this.isAuth) {
                    this.logger.log(LoggingType.INFO, "Send auth packet to server.");
                    this.send((Packet)new AuthPacket(UUID.randomUUID().toString()));
                }
                if (this.reader.read() <= 0 || (serverResponse = this.reader.readLine()) == null) continue;
                serverResponse = "{" + (String)serverResponse;
                Packet packet = this.packetManager.fromJson((String)serverResponse);
                if (this.isAuth) {
                    this.clientReceivedEvent.onClientReceived((IClient)this, packet);
                }
                if (!(packet instanceof AuthResponsePacket)) continue;
                AuthResponsePacket authResponsePacket = (AuthResponsePacket)packet;
                if (authResponsePacket.isSuccess()) {
                    this.id = authResponsePacket.getId();
                    this.isAuth = true;
                    this.clientConnectEvent.onClientConnect((IClient)this);
                    continue;
                }
                this.send((Packet)new AuthPacket(UUID.randomUUID().toString()));
                this.logger.log(LoggingType.INFO, "Send auth packet to server.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send(Packet packet) {
        this.writer.println(this.packetManager.toJson(packet));
        this.writer.flush();
        this.clientSendEvent.onClientSend((IClient)this, packet);
    }

    public NexonetLogger getLogger() {
        return this.logger;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void disconnect() {
        try {
            this.logger.log(LoggingType.INFO, "Client Try to Disconnect!");
            this.send((Packet)new DisconnectPacket(0));
            this.clientDisconnectEvent.onClientDisconnect((IClient)this);
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isAuth() {
        return this.isAuth;
    }

    public void setAuth(boolean auth) {
        this.isAuth = auth;
    }

    public void onClientConnect(ClientConnectEvent event) {
        this.clientConnectEvent = event;
    }

    public void onClientDisconnect(ClientDisconnectEvent event) {
        this.clientDisconnectEvent = event;
    }

    public void onClientReceived(ClientReceivedEvent event) {
        this.clientReceivedEvent = event;
    }

    public void onClientSend(ClientSendEvent event) {
        this.clientSendEvent = event;
    }

    public IPacketManager getPacketManager() {
        return this.packetManager;
    }
}

