/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.config;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import de.eztxm.api.config.Config;
import de.eztxm.object.ObjectConverter;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class TomlConfig
implements Config {
    private final TomlMapper tomlMapper;
    private final File configFile;

    public TomlConfig(String path, String configName) {
        File folder = new File(path);
        this.configFile = new File(path + "/" + configName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
                this.tomlMapper = new TomlMapper();
                this.tomlMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.tomlMapper = new TomlMapper();
        }
    }

    public void set(String key, Object value) {
        try {
            Object obj = this.tomlMapper.readValue(this.configFile, Object.class);
            ((Map)obj).put(key, value);
            this.tomlMapper.writeValue(this.configFile, obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(String key) {
        try {
            Object obj = this.tomlMapper.readValue(this.configFile, Object.class);
            ((Map)obj).remove(key);
            this.tomlMapper.writeValue(this.configFile, obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectConverter get(String key) {
        try {
            Object obj = this.tomlMapper.readValue(this.configFile, Object.class);
            Object value = ((Map)obj).get(key);
            if (value == null) {
                return null;
            }
            return new ObjectConverter(value);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void addDefault(String key, Object value) {
        if (this.get(key) != null) {
            return;
        }
        this.set(key, value);
    }
}

