/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import de.eztxm.ezlib.api.config.Config;
import de.eztxm.ezlib.object.ObjectConverter;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class PropertiesConfig
implements Config {
    private final ObjectMapper objectMapper;
    private final File configFile;

    public PropertiesConfig(String path, String configName) {
        File folder = new File(path);
        this.configFile = new File(path + "/" + configName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
                this.objectMapper = new JavaPropsMapper();
                this.objectMapper.writeValue(this.configFile, (Object)new Properties());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.objectMapper = new JavaPropsMapper();
        }
    }

    public void set(String key, Object value) {
        try {
            Properties properties = (Properties)this.objectMapper.readValue(this.configFile, Properties.class);
            properties.setProperty(key, String.valueOf(value));
            this.objectMapper.writeValue(this.configFile, (Object)properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(String key) {
        try {
            Properties properties = (Properties)this.objectMapper.readValue(this.configFile, Properties.class);
            properties.remove(key);
            this.objectMapper.writeValue(this.configFile, (Object)properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectConverter get(String key) {
        try {
            Properties properties = (Properties)this.objectMapper.readValue(this.configFile, Properties.class);
            String value = properties.getProperty(key);
            if (value == null) {
                return null;
            }
            return new ObjectConverter((Object)value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addDefault(String key, Object value) {
        if (this.get(key) != null) {
            return;
        }
        this.set(key, value);
    }
}

