/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.nexonet.server;

import com.nexoscript.nexonet.api.events.server.ServerClientConnectEvent;
import com.nexoscript.nexonet.api.events.server.ServerClientDisconnectEvent;
import com.nexoscript.nexonet.api.events.server.ServerReceivedEvent;
import com.nexoscript.nexonet.api.events.server.ServerSendEvent;
import com.nexoscript.nexonet.api.networking.IClientHandler;
import com.nexoscript.nexonet.api.networking.IServer;
import com.nexoscript.nexonet.api.packet.IPacketManager;
import com.nexoscript.nexonet.api.packet.Packet;
import com.nexoscript.nexonet.logger.LoggingType;
import com.nexoscript.nexonet.logger.NexonetLogger;
import com.nexoscript.nexonet.packet.PacketManager;
import com.nexoscript.nexonet.packet.impl.AuthPacket;
import com.nexoscript.nexonet.packet.impl.AuthResponsePacket;
import com.nexoscript.nexonet.packet.impl.DisconnectPacket;
import com.nexoscript.nexonet.server.ClientHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class Server
implements IServer {
    private List<IClientHandler> clients;
    private boolean logging;
    private NexonetLogger logger;
    private boolean isRunning = false;
    private int port;
    private String hostname = "127.0.0.1";
    private InetSocketAddress ip;
    private ServerClientConnectEvent clientConnectEvent;
    private ServerClientDisconnectEvent clientDisconnectEvent;
    private ServerReceivedEvent serverReceivedEvent;
    private ServerSendEvent serverSendEvent;
    private IPacketManager packetManager;

    public Server() {
        this.logging = false;
        this.logger = new NexonetLogger(false);
        this.packetManager = new PacketManager();
        this.initialize();
    }

    public Server(String hostname) {
        this.hostname = hostname;
        this.logging = false;
        this.logger = new NexonetLogger(false);
        this.packetManager = new PacketManager();
        this.initialize();
    }

    public Server(boolean logging) {
        this.logging = logging;
        this.logger = new NexonetLogger(logging);
        this.packetManager = new PacketManager(this.logger);
        this.initialize();
    }

    private void initialize() {
        this.clients = new ArrayList<IClientHandler>();
        this.packetManager.registerPacketType("AUTH", AuthPacket.class);
        this.packetManager.registerPacketType("AUTH_RESPONSE", AuthResponsePacket.class);
        this.packetManager.registerPacketType("DISCONNECT", DisconnectPacket.class);
        this.clientConnectEvent = client -> {};
        this.clientDisconnectEvent = client -> {};
        this.serverReceivedEvent = (client, packet) -> {};
        this.serverSendEvent = (client, packet) -> {};
    }

    public void start(int port) {
        this.port = port;
        this.ip = new InetSocketAddress(this.hostname, this.port);
        this.isRunning = true;
        this.logger.log(LoggingType.INFO, "Starting Nexonet server...");
        try (ServerSocket serverSocket = new ServerSocket(this.ip.getPort());){
            this.logger.log(LoggingType.INFO, "Waiting for client connections...");
            while (this.isRunning) {
                Socket clientSocket = serverSocket.accept();
                ClientHandler clientHandler = new ClientHandler(clientSocket, this, this.packetManager);
                this.logger.log(LoggingType.INFO, "Client connected: " + String.valueOf(clientSocket.getInetAddress()));
                new Thread(clientHandler).start();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NexonetLogger getLogger() {
        return this.logger;
    }

    public List<IClientHandler> getClients() {
        return this.clients;
    }

    public void sendToClient(String clientID, Packet packet) {
        this.getClients().forEach(client -> {
            if (client.getId().equalsIgnoreCase(clientID)) {
                client.getWriter().println(this.packetManager.toJson(packet));
                client.getWriter().flush();
                this.serverSendEvent.onServerSend(client, packet);
            }
        });
    }

    public void sendToClients(Packet packet) {
        this.getClients().forEach(client -> {
            client.getWriter().println(this.packetManager.toJson(packet));
            client.getWriter().flush();
            this.serverSendEvent.onServerSend(client, packet);
        });
    }

    public void onClientConnect(ServerClientConnectEvent event) {
        this.clientConnectEvent = event;
    }

    public void onClientDisconnect(ServerClientDisconnectEvent event) {
        this.clientDisconnectEvent = event;
    }

    public void onServerReceived(ServerReceivedEvent event) {
        this.serverReceivedEvent = event;
    }

    public void onServerSend(ServerSendEvent event) {
        this.serverSendEvent = event;
    }

    public ServerClientConnectEvent getClientConnectEvent() {
        return this.clientConnectEvent;
    }

    public ServerClientDisconnectEvent getClientDisconnectEvent() {
        return this.clientDisconnectEvent;
    }

    public ServerReceivedEvent getServerReceivedEvent() {
        return this.serverReceivedEvent;
    }

    public ServerSendEvent getServerSendEvent() {
        return this.serverSendEvent;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetSocketAddress getIpAddress() {
        return this.ip;
    }

    public void setIpAddress(InetSocketAddress ipAddress) {
        this.ip = ipAddress;
    }

    public IPacketManager getPacketManager() {
        return this.packetManager;
    }
}

