/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.database;

import com.zaxxer.hikari.pool.HikariPool;
import de.eztxm.api.database.SQLConnection;
import de.eztxm.database.Arguments;
import de.eztxm.database.SQLDatabaseConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class MariaDBConnection
implements SQLConnection {
    private final HikariPool pool;
    private final ExecutorService service;

    public MariaDBConnection(String host, int port, String database, String username, String password) {
        SQLDatabaseConnection databaseConnection = new SQLDatabaseConnection();
        databaseConnection.create("mariadb", host, port, database, username, password);
        this.pool = databaseConnection.connect();
        this.service = databaseConnection.newCachedThread();
    }

    public ResultSet query(String sql, Object ... objects) {
        ResultSet resultSet;
        block8: {
            Connection connection = this.pool.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                this.setArguments(objects, preparedStatement);
                resultSet = preparedStatement.executeQuery();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.fillInStackTrace();
                    return null;
                }
            }
            connection.close();
        }
        return resultSet;
    }

    public void put(String sql, Object ... objects) {
        try (Connection connection = this.pool.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            this.setArguments(objects, preparedStatement);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.fillInStackTrace();
        }
    }

    public CompletableFuture<ResultSet> queryAsync(String sql, Object ... objects) {
        return CompletableFuture.supplyAsync(() -> this.query(sql, objects), this.service);
    }

    public CompletableFuture<Void> putAsync(String sql, Object ... objects) {
        return CompletableFuture.runAsync(() -> this.put(sql, objects), this.service);
    }

    public void close() {
        try {
            this.pool.shutdown();
        }
        catch (InterruptedException e) {
            e.fillInStackTrace();
        }
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.runAsync(this::close, this.service);
    }

    private void setArguments(Object[] objects, PreparedStatement preparedStatement) throws SQLException {
        Arguments.set((Object[])objects, (PreparedStatement)preparedStatement);
    }

    public CompletableFuture<HikariPool> getPoolAsync() {
        return CompletableFuture.supplyAsync(this::getPool, this.service);
    }

    public HikariPool getPool() {
        return this.pool;
    }

    public ExecutorService getService() {
        return this.service;
    }
}

