/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.nexonet.packet;

import com.nexoscript.nexonet.api.crypto.CryptoType;
import com.nexoscript.nexonet.api.crypto.KeySize;
import com.nexoscript.nexonet.api.packet.IPacketManager;
import com.nexoscript.nexonet.api.packet.Packet;
import com.nexoscript.nexonet.logger.NexonetLogger;
import com.nexoscript.nexonet.packet.crypto.CryptoManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PacketManager
implements IPacketManager {
    private final Map<String, Class<? extends Packet>> packetRegistry = new HashMap<String, Class<? extends Packet>>();
    private final NexonetLogger logger;
    private final CryptoManager cryptoManager;
    private boolean useEncryption = true;

    public PacketManager(NexonetLogger logger, String path, CryptoType type, KeySize size) {
        this.logger = logger;
        this.cryptoManager = new CryptoManager(this.logger);
        this.cryptoManager.initCrypto(path, type, size);
    }

    public PacketManager(NexonetLogger logger) {
        this.logger = logger;
        this.cryptoManager = new CryptoManager(this.logger);
        this.useEncryption = false;
    }

    public void registerPacketType(String type, Class<? extends Packet> clazz) {
        this.packetRegistry.put(type, clazz);
    }

    public String toJson(Packet packet) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)packet.getType());
        Field[] fields = packet.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                json.put(field.getName(), field.get(packet));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (this.useEncryption) {
            System.out.println("[Crypto Decrypted] : " + String.valueOf(json));
            String s = this.cryptoManager.encryptString(json.toString());
            System.out.println("[Crypto Encrypted] : " + s);
            return s;
        }
        return json.toString();
    }

    public Packet fromJson(String jsonString) {
        try {
            Field[] fields;
            String encrytedString = jsonString;
            System.out.println("[Crypto Encrypted] : " + encrytedString);
            if (this.useEncryption) {
                encrytedString = this.cryptoManager.decryptString(jsonString);
            }
            System.out.println("[Crypto Decrypted] : " + encrytedString);
            JSONObject json = new JSONObject(encrytedString);
            String type = json.getString("type");
            Class<? extends Packet> clazz = this.packetRegistry.get(type);
            if (clazz == null) {
                throw new IllegalArgumentException("Unknown packet type: " + type);
            }
            Packet packet = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (!json.has(field.getName())) continue;
                Object value = json.get(field.getName());
                field.set(packet, value);
            }
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

