/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.downloader;

import de.eztxm.ezlib.api.http.Authentication;
import de.eztxm.ezlib.downloader.BasicAuthentication;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;

public class Downloader {
    private final String url;
    private final Path saveDirectory;
    private Authentication authentication;

    public Downloader(String url, Path saveDirectory) {
        this.url = url;
        this.saveDirectory = saveDirectory;
    }

    public Downloader(String url, Path saveDirectory, Authentication authentication) {
        this.url = url;
        this.saveDirectory = saveDirectory;
        this.authentication = authentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File downloadFile() {
        HttpURLConnection connection = null;
        try {
            Authentication authentication;
            URL downloadUrl = URI.create(this.url).toURL();
            connection = (HttpURLConnection)downloadUrl.openConnection();
            connection.setRequestMethod("GET");
            if (this.authentication != null && (authentication = this.authentication) instanceof BasicAuthentication) {
                BasicAuthentication basicAuth = (BasicAuthentication)authentication;
                String auth = basicAuth.getUsername() + ":" + basicAuth.getPassword();
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
                connection.setRequestProperty("Content-Type", "application/json");
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    String fileName = this.extractFileName(connection);
                    if (fileName.isEmpty()) {
                        fileName = downloadUrl.getPath().substring(downloadUrl.getPath().lastIndexOf("/") + 1);
                    }
                    Path saveFilePath = this.saveDirectory.resolve(fileName);
                    if (Files.notExists(this.saveDirectory, new LinkOption[0])) {
                        Files.createDirectories(this.saveDirectory, new FileAttribute[0]);
                    }
                    try (InputStream inputStream = connection.getInputStream();){
                        Files.copy(inputStream, saveFilePath, new CopyOption[0]);
                    }
                    System.out.println("File downloaded to " + String.valueOf(saveFilePath));
                    File file = saveFilePath.toFile();
                    return file;
                }
                case 403: {
                    System.out.println("Access denied (403)");
                    return null;
                }
                case 401: {
                    System.out.println("Unauthorized (401)");
                    return null;
                }
                case 404: {
                    System.out.println("Not found (404)");
                    return null;
                }
                default: {
                    System.out.println("Unexpected response code: " + responseCode);
                    return null;
                }
            }
        }
        catch (IOException e) {
            System.err.println("Download failed: " + e.getMessage());
            return null;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String extractFileName(HttpURLConnection connection) {
        String disposition = connection.getHeaderField("Content-Disposition");
        String filenameStar = null;
        String filename = null;
        if (disposition != null) {
            String[] parts;
            for (String part : parts = disposition.split(";")) {
                part = part.trim();
                String trimmed = part.substring(part.indexOf(61) + 1).trim();
                if (part.startsWith("filename*=")) {
                    filenameStar = trimmed;
                    int encodingIdx = filenameStar.indexOf("''");
                    if (encodingIdx != -1) {
                        filenameStar = filenameStar.substring(encodingIdx + 2);
                    }
                    filenameStar = filenameStar.replaceAll("\"", "");
                }
                if (!part.startsWith("filename=")) continue;
                filename = trimmed.replaceAll("\"", "");
            }
        }
        if (filenameStar != null && !filenameStar.isEmpty()) {
            return filenameStar;
        }
        if (filename != null && !filename.isEmpty()) {
            return filename;
        }
        return "";
    }
}

