/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.pool.HikariPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SQLDatabaseConnection {
    private HikariPool pool;
    private HikariConfig config;

    public SQLDatabaseConnection create(String jdbcDriver, String host, int port, String database, String username, String password) {
        this.config = new HikariConfig();
        this.config.setConnectionTimeout(7500L);
        this.config.setMaximumPoolSize(8);
        this.config.setMinimumIdle(1);
        this.config.setJdbcUrl(String.format("jdbc:" + jdbcDriver + "://%s:%s/%s?autoReconnect=true", host, port, database));
        this.config.setUsername(username);
        this.config.setPassword(password);
        return this;
    }

    public SQLDatabaseConnection create(String jdbcDriver, String path, String file) {
        this.config = new HikariConfig();
        this.config.setConnectionTimeout(7500L);
        this.config.setMaximumPoolSize(8);
        this.config.setMinimumIdle(1);
        this.config.setJdbcUrl(String.format("jdbc:" + jdbcDriver + ":%s/%s", System.getProperty("user.dir") + "/" + path, file));
        return this;
    }

    public ExecutorService newCachedThread() {
        return Executors.newCachedThreadPool();
    }

    public HikariPool connect() {
        HikariPool hikariPool;
        block8: {
            this.pool = new HikariPool(this.config);
            Connection connection = this.pool.getConnection();
            try {
                PreparedStatement statement = connection.prepareStatement("SELECT 1");
                statement.setQueryTimeout(15);
                statement.executeQuery();
                hikariPool = this.pool;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return null;
                }
            }
            connection.close();
        }
        return hikariPool;
    }

    public HikariPool getPool() {
        return this.pool;
    }

    public HikariConfig getConfig() {
        return this.config;
    }
}

