/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.reflect;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.eztxm.ezlib.config.annotation.JsonClassConfig;
import java.io.File;
import lombok.Generated;

public class JsonProcessor<T> {
    private final T instance;

    public JsonProcessor(T instance) {
        this.instance = instance;
        if (!instance.getClass().isAnnotationPresent(JsonClassConfig.class)) {
            throw new IllegalStateException("Klasse " + instance.getClass().getName() + " hat keine JsonClassConfig-Annotation!");
        }
    }

    public void saveConfiguration() {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
        JsonClassConfig configuration = this.instance.getClass().getAnnotation(JsonClassConfig.class);
        File file = new File(configuration.path(), configuration.fileName());
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        writer.writeValue(file, this.instance);
    }

    public static <T> JsonProcessor<T> loadConfiguration(Class<T> clazz) {
        if (!clazz.isAnnotationPresent(JsonClassConfig.class)) {
            throw new IllegalStateException("Klasse " + clazz.getName() + " hat keine JsonClassConfig-Annotation!");
        }
        JsonClassConfig configuration = clazz.getAnnotation(JsonClassConfig.class);
        File file = new File(configuration.path(), configuration.fileName());
        ObjectMapper objectMapper = new ObjectMapper();
        Object instance = file.exists() && file.length() > 0L ? objectMapper.readValue(file, clazz) : clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return new JsonProcessor<T>(instance);
    }

    @Generated
    public T getInstance() {
        return this.instance;
    }
}

