/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.object;

import de.eztxm.ezlib.config.object.JsonArray;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class JsonObject {
    private final Map<String, Object> elements = new LinkedHashMap<String, Object>();

    public void set(String key, Object value) {
        this.elements.put(key, value);
    }

    public void remove(String key) {
        this.elements.remove(key);
    }

    public Object get(String key) {
        return this.elements.get(key);
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.elements.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"").append(this.escape(entry.getKey())).append("\":").append(this.valueToString(entry.getValue()));
        }
        sb.append("}");
        return sb.toString();
    }

    public String toJsonString(boolean prettyPrint) {
        if (!prettyPrint) {
            return this.toJsonString();
        }
        return JsonObject.formatJson(this.toJsonString(), 4);
    }

    private static String formatJson(String json, int indentFactor) {
        StringBuilder formattedJson = new StringBuilder();
        int indent = 0;
        boolean inQuotes = false;
        block7: for (char c : json.toCharArray()) {
            switch (c) {
                case '[': 
                case '{': {
                    formattedJson.append(c);
                    if (inQuotes) continue block7;
                    formattedJson.append("\n").append(" ".repeat(indent += indentFactor));
                    continue block7;
                }
                case ']': 
                case '}': {
                    if (!inQuotes) {
                        formattedJson.append("\n").append(" ".repeat(indent -= indentFactor));
                    }
                    formattedJson.append(c);
                    continue block7;
                }
                case '\"': {
                    formattedJson.append(c);
                    inQuotes = !inQuotes;
                    continue block7;
                }
                case ',': {
                    formattedJson.append(c);
                    if (inQuotes) continue block7;
                    formattedJson.append("\n").append(" ".repeat(indent));
                    continue block7;
                }
                case ':': {
                    formattedJson.append(c);
                    if (inQuotes) continue block7;
                    formattedJson.append(" ");
                    continue block7;
                }
                default: {
                    formattedJson.append(c);
                }
            }
        }
        return formattedJson.toString();
    }

    private String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + this.escape((String)value) + "\"";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JsonObject || value instanceof JsonArray) {
            return value.toString();
        }
        if (value instanceof Iterable) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (Object item : (Iterable)value) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(this.valueToString(item));
            }
            sb.append("]");
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Object item = Array.get(value, i);
                sb.append(this.valueToString(item));
            }
            sb.append("]");
            return sb.toString();
        }
        return "\"" + this.escape(value.toString()) + "\"";
    }

    private String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static JsonObject parse(String json) {
        String[] pairs;
        JsonObject obj = new JsonObject();
        if (!(json = json.trim()).startsWith("{") || !json.endsWith(" ")) {
            throw new IllegalArgumentException("Invalid JSON object");
        }
        if ((json = json.substring(1, json.length() - 1).trim()).isEmpty()) {
            return obj;
        }
        for (String pair : pairs = json.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")) {
            String[] keyValue = pair.split(":(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            Object parsedValue = JsonObject.parseValue(value);
            obj.set(key, parsedValue);
        }
        return obj;
    }

    public static Object parseValue(String value) {
        switch (value) {
            case "null": {
                return null;
            }
            case "true": {
                return Boolean.TRUE;
            }
            case "false": {
                return Boolean.FALSE;
            }
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return JsonObject.unescape(value.substring(1, value.length() - 1));
        }
        try {
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public JsonObject deepCopy() {
        JsonObject copy = new JsonObject();
        for (Map.Entry<String, Object> entry : this.elements.entrySet()) {
            copy.set(entry.getKey(), JsonObject.deepCopyValue(entry.getValue()));
        }
        return copy;
    }

    private static Object deepCopyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonObject) {
            return ((JsonObject)value).deepCopy();
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).deepCopy();
        }
        if (value instanceof List) {
            ArrayList<Object> copyList = new ArrayList<Object>();
            for (Object item : (List)value) {
                copyList.add(JsonObject.deepCopyValue(item));
            }
            return copyList;
        }
        if (value instanceof Map) {
            LinkedHashMap copyMap = new LinkedHashMap();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                copyMap.put(entry.getKey(), JsonObject.deepCopyValue(entry.getValue()));
            }
            return copyMap;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            Object copyArray = Array.newInstance(value.getClass().getComponentType(), len);
            for (int i = 0; i < len; ++i) {
                Array.set(copyArray, i, JsonObject.deepCopyValue(Array.get(value, i)));
            }
            return copyArray;
        }
        return value;
    }

    private static String unescape(String s) {
        return s.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\b", "\b").replace("\\f", "\f").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
    }

    @Generated
    public Map<String, Object> getElements() {
        return this.elements;
    }
}

