/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.object;

import de.eztxm.ezlib.config.object.JsonObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class JsonArray
implements Iterable<Object> {
    private final List<Object> elements = new ArrayList<Object>();

    public void add(Object value) {
        this.elements.add(value);
    }

    public void remove(int index) {
        this.elements.remove(index);
    }

    public boolean contains(Object value) {
        return this.elements.contains(value);
    }

    public Object get(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    @Override
    public void forEach(Consumer<? super Object> action) {
        this.elements.forEach(action);
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int len = this.elements.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.valueToString(this.elements.get(i)));
        }
        sb.append("]");
        return sb.toString();
    }

    public String toJsonString(boolean prettyPrint) {
        if (!prettyPrint) {
            return this.toJsonString();
        }
        return JsonArray.formatJson(this.toJsonString(), 4);
    }

    private static String formatJson(String json, int indentFactor) {
        StringBuilder formattedJson = new StringBuilder();
        int indent = 0;
        boolean inQuotes = false;
        block7: for (char c : json.toCharArray()) {
            switch (c) {
                case '[': 
                case '{': {
                    formattedJson.append(c);
                    if (inQuotes) continue block7;
                    formattedJson.append("\n").append(" ".repeat(indent += indentFactor));
                    continue block7;
                }
                case ']': 
                case '}': {
                    if (!inQuotes) {
                        formattedJson.append("\n").append(" ".repeat(indent -= indentFactor));
                    }
                    formattedJson.append(c);
                    continue block7;
                }
                case '\"': {
                    formattedJson.append(c);
                    inQuotes = !inQuotes;
                    continue block7;
                }
                case ',': {
                    formattedJson.append(c);
                    if (inQuotes) continue block7;
                    formattedJson.append("\n").append(" ".repeat(indent));
                    continue block7;
                }
                case ':': {
                    formattedJson.append(c);
                    if (inQuotes) continue block7;
                    formattedJson.append(" ");
                    continue block7;
                }
                default: {
                    formattedJson.append(c);
                }
            }
        }
        return formattedJson.toString();
    }

    private String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + this.escape((String)value) + "\"";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JsonObject || value instanceof JsonArray) {
            return value.toString();
        }
        if (value instanceof Iterable) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int index = 0;
            for (Object item : (Iterable)value) {
                if (index > 0) {
                    sb.append(",");
                }
                sb.append(this.valueToString(item));
                ++index;
            }
            sb.append("]");
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Object item = Array.get(value, i);
                sb.append(this.valueToString(item));
            }
            sb.append("]");
            return sb.toString();
        }
        return "\"" + this.escape(value.toString()) + "\"";
    }

    private String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static JsonArray parse(String json) {
        String[] items;
        JsonArray arr = new JsonArray();
        if (!(json = json.trim()).startsWith("[") || !json.endsWith("]")) {
            throw new IllegalArgumentException("Invalid JSON array");
        }
        if ((json = json.substring(1, json.length() - 1).trim()).isEmpty()) {
            return arr;
        }
        for (String item : items = json.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")) {
            Object parsedItem = JsonObject.parseValue(item.trim());
            arr.add(parsedItem);
        }
        return arr;
    }

    public JsonArray deepCopy() {
        JsonArray copy = new JsonArray();
        for (Object value : this.elements) {
            copy.add(JsonArray.deepCopyValue(value));
        }
        return copy;
    }

    private static Object deepCopyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonObject) {
            return ((JsonObject)value).deepCopy();
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).deepCopy();
        }
        if (value instanceof List) {
            ArrayList<Object> copyList = new ArrayList<Object>();
            for (Object item : (List)value) {
                copyList.add(JsonArray.deepCopyValue(item));
            }
            return copyList;
        }
        if (value instanceof Map) {
            LinkedHashMap copyMap = new LinkedHashMap();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                copyMap.put(entry.getKey(), JsonArray.deepCopyValue(entry.getValue()));
            }
            return copyMap;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            Object copyArray = Array.newInstance(value.getClass().getComponentType(), len);
            for (int i = 0; i < len; ++i) {
                Array.set(copyArray, i, JsonArray.deepCopyValue(Array.get(value, i)));
            }
            return copyArray;
        }
        return value;
    }

    @Generated
    public List<Object> getElements() {
        return this.elements;
    }
}

