/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config;

import de.eztxm.ezlib.api.config.Config;
import de.eztxm.ezlib.config.object.JsonObject;
import de.eztxm.ezlib.config.object.ObjectConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;

public class JsonConfig
implements Config {
    private final Path configFolder;
    private String configName;
    private boolean autoSave;
    private JsonObject customJsonObject;

    public JsonConfig(String path, String configName) {
        this(path, configName, true);
    }

    public JsonConfig(String path, String configName, boolean autoSave) {
        this.configFolder = Paths.get(path, new String[0]);
        this.configName = configName;
        this.autoSave = autoSave;
        try {
            Path configFile;
            if (Files.notExists(this.configFolder, new LinkOption[0])) {
                Files.createDirectories(this.configFolder, new FileAttribute[0]);
            }
            if (Files.notExists(configFile = this.configFolder.resolve(configName), new LinkOption[0])) {
                Files.createFile(configFile, new FileAttribute[0]);
                this.customJsonObject = new JsonObject();
                if (autoSave) {
                    this.save();
                }
                return;
            }
            String configJson = Files.readString(configFile);
            if (configJson.trim().isEmpty()) {
                this.customJsonObject = new JsonObject();
                return;
            }
            try {
                this.customJsonObject = JsonObject.parse(configJson);
            }
            catch (Exception e) {
                this.customJsonObject = new JsonObject();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Initialisieren der Konfiguration: " + e.getMessage(), e);
        }
    }

    public void set(String key, Object value) {
        this.customJsonObject.set(key, value);
        if (this.autoSave) {
            this.save();
        }
    }

    public void remove(String key) {
        this.customJsonObject.remove(key);
        if (this.autoSave) {
            this.save();
        }
    }

    public Object getObject(String key) {
        return this.customJsonObject.get(key);
    }

    public ObjectConverter get(String key) {
        return new ObjectConverter(this.customJsonObject.get(key));
    }

    public void addDefault(String key, Object value) {
        if (this.getObject(key) != null) {
            return;
        }
        this.set(key, value);
    }

    public void save() {
        Path configFile = this.configFolder.resolve(this.configName);
        try {
            Files.writeString(configFile, (CharSequence)this.customJsonObject.toJsonString(true), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Speichern der Konfiguration: " + e.getMessage(), e);
        }
    }

    @Generated
    public Path getConfigFolder() {
        return this.configFolder;
    }

    @Generated
    public String getConfigName() {
        return this.configName;
    }

    @Generated
    public boolean isAutoSave() {
        return this.autoSave;
    }

    @Generated
    public JsonObject getCustomJsonObject() {
        return this.customJsonObject;
    }
}

