/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.nexonet.logger;

import com.nexoscript.nexonet.logger.LoggingType;

public class NexonetLogger {
    private final boolean logging;

    public NexonetLogger(boolean logging) {
        this.logging = logging;
    }

    public void log(LoggingType loggingType, String message) {
        this.log(loggingType, message, true);
    }

    public void log(LoggingType loggingType, String message, boolean newLine) {
        if (this.logging) {
            StringBuilder builder = new StringBuilder();
            switch (loggingType) {
                case INFO: {
                    builder.append("\u001b[0;37m");
                    break;
                }
                case WARN: {
                    builder.append("\u001b[0;33m");
                    break;
                }
                case ERROR: {
                    builder.append("\u001b[0;31m");
                }
            }
            builder.append("[").append(loggingType.name()).append("] ").append(message).append("\u001b[0m");
            if (newLine) {
                builder.append("\n");
            }
            System.out.print(builder);
        }
    }
}

