/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.config.object;

import de.eztxm.config.JsonConfig;
import de.eztxm.config.object.JsonArray;
import de.eztxm.config.object.JsonObject;
import java.util.Collections;
import java.util.List;

public class ObjectConverter {
    private final JsonConfig jsonConfig;
    private final Object object;

    public ObjectConverter(JsonConfig jsonConfig, Object object) {
        this.jsonConfig = jsonConfig;
        this.object = object;
    }

    public ObjectConverter(Object object) {
        this.jsonConfig = null;
        this.object = object;
    }

    public Object asObject() {
        try {
            return this.object;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String asString() {
        try {
            return this.object.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean asBoolean() {
        try {
            return (Boolean)this.object;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int asInteger() {
        try {
            return (Integer)this.object;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public double asDouble() {
        try {
            return (Double)this.object;
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public float asFloat() {
        try {
            return ((Float)this.object).floatValue();
        }
        catch (Exception e) {
            return -1.0f;
        }
    }

    public List<Object> asList() {
        try {
            return Collections.singletonList(this.object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonObject asJsonObject() {
        try {
            return new JsonObject(this.jsonConfig, this.object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonArray asJsonArray() {
        try {
            return (JsonArray)this.object;
        }
        catch (Exception e) {
            return null;
        }
    }
}

