/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.dsm.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConsoleColor {
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("\\[([A-Fa-f0-9]{6})-([A-Fa-f0-9]{6})](.*?)(?=\\[|&|$)");
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("&([0-9A-Fa-fLl])");
    private static final Pattern HEX_PATTERN = Pattern.compile("\\[([A-Fa-f0-9]{6})](.*?)(?=\\[|&|$)");
    private static final String[] ANSI_COLORS = new String[]{"\u001b[30m", "\u001b[34m", "\u001b[32m", "\u001b[36m", "\u001b[31m", "\u001b[35m", "\u001b[33m", "\u001b[37m", "\u001b[90m", "\u001b[94m", "\u001b[92m", "\u001b[96m", "\u001b[91m", "\u001b[95m", "\u001b[93m", "\u001b[97m", "\u001b[0m"};

    public static String apply(String text) {
        text = ConsoleColor.applyGradients(text);
        text = ConsoleColor.applyHexColors(text);
        text = ConsoleColor.applyColorCodes(text);
        return text + "\u001b[0m";
    }

    private static String applyGradients(String text) {
        Matcher gradientMatcher = GRADIENT_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (gradientMatcher.find()) {
            String startColor = gradientMatcher.group(1);
            String endColor = gradientMatcher.group(2);
            String gradientText = gradientMatcher.group(3);
            String replacement = ConsoleColor.applyGradient(startColor, endColor, gradientText);
            gradientMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        gradientMatcher.appendTail(result);
        return result.toString();
    }

    private static String applyHexColors(String text) {
        Matcher hexMatcher = HEX_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (hexMatcher.find()) {
            String hexColor = hexMatcher.group(1);
            String hexText = hexMatcher.group(2);
            String replacement = ConsoleColor.rgb(hexColor) + hexText;
            hexMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        hexMatcher.appendTail(result);
        return result.toString();
    }

    private static String applyColorCodes(String text) {
        Matcher colorCodeMatcher = COLOR_CODE_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (colorCodeMatcher.find()) {
            char colorCode = Character.toLowerCase(colorCodeMatcher.group(1).charAt(0));
            int index = colorCode >= '0' && colorCode <= '9' ? colorCode - 48 : (colorCode >= 'a' && colorCode <= 'f' ? colorCode - 97 + 10 : 16);
            String replacement = index >= 0 && index < ANSI_COLORS.length ? ANSI_COLORS[index] : "";
            colorCodeMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        colorCodeMatcher.appendTail(result);
        return result.toString();
    }

    public static String rgb(String hexColor) {
        int r = Integer.parseInt(hexColor.substring(0, 2), 16);
        int g = Integer.parseInt(hexColor.substring(2, 4), 16);
        int b = Integer.parseInt(hexColor.substring(4, 6), 16);
        return String.format("\u001b[38;2;%d;%d;%dm", r, g, b);
    }

    public static String gradient(String startColor, String endColor, String text) {
        return ConsoleColor.applyGradient(startColor, endColor, text);
    }

    private static String applyGradient(String startColor, String endColor, String text) {
        int length = text.length();
        StringBuilder result = new StringBuilder();
        int r1 = Integer.parseInt(startColor.substring(0, 2), 16);
        int g1 = Integer.parseInt(startColor.substring(2, 4), 16);
        int b1 = Integer.parseInt(startColor.substring(4, 6), 16);
        int r2 = Integer.parseInt(endColor.substring(0, 2), 16);
        int g2 = Integer.parseInt(endColor.substring(2, 4), 16);
        int b2 = Integer.parseInt(endColor.substring(4, 6), 16);
        for (int i = 0; i < length; ++i) {
            double ratio = (double)i / (double)(length - 1);
            int red = (int)((double)r1 + ratio * (double)(r2 - r1));
            int green = (int)((double)g1 + ratio * (double)(g2 - g1));
            int blue = (int)((double)b1 + ratio * (double)(b2 - b1));
            result.append(String.format("\u001b[38;2;%d;%d;%dm", red, green, blue)).append(text.charAt(i));
        }
        return result.toString() + "\u001b[0m";
    }
}

