/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.object;

import de.eztxm.ezlib.config.object.JsonArray;
import de.eztxm.ezlib.config.object.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ObjectConverter {
    private final Object object;

    public ObjectConverter(Object object) {
        this.object = object;
    }

    public Object asObject() {
        return this.object;
    }

    public String asString() {
        if (this.object != null) {
            return this.object.toString();
        }
        return null;
    }

    public boolean asBoolean() {
        try {
            if (this.object instanceof Boolean) {
                return (Boolean)this.object;
            }
            return Boolean.parseBoolean(this.asString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public int asInteger() {
        try {
            if (this.object instanceof Number) {
                return ((Number)this.object).intValue();
            }
            return Integer.parseInt(this.asString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public double asDouble() {
        try {
            if (this.object instanceof Number) {
                return ((Number)this.object).doubleValue();
            }
            return Double.parseDouble(this.asString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public float asFloat() {
        try {
            if (this.object instanceof Number) {
                return ((Number)this.object).floatValue();
            }
            return Float.parseFloat(this.asString());
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public List<Object> asList() {
        try {
            if (this.object instanceof List) {
                return (List)this.object;
            }
            return Collections.singletonList(this.object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonObject asJsonObject() {
        try {
            if (this.object instanceof JsonObject) {
                return (JsonObject)this.object;
            }
            if (this.object instanceof String) {
                return JsonObject.parse((String)this.object);
            }
            Object object = this.object;
            if (object instanceof Map) {
                Map map = (Map)object;
                JsonObject jObj = new JsonObject();
                for (Map.Entry entry : map.entrySet()) {
                    jObj.put(entry.getKey().toString(), entry.getValue());
                }
                return jObj;
            }
            return JsonObject.parse(this.object.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> JsonArray<T> asJsonArray(Class<T> clazz) {
        try {
            Object object = this.object;
            if (object instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)object;
                return jsonArray;
            }
            object = this.object;
            if (object instanceof String) {
                String jsonStr = (String)object;
                return JsonArray.parse(jsonStr, clazz);
            }
            object = this.object;
            if (object instanceof List) {
                List list = (List)object;
                JsonArray arr = new JsonArray();
                for (Object item : list) {
                    arr.add(clazz.cast(item));
                }
                return arr;
            }
            JsonArray arr = new JsonArray();
            arr.add(clazz.cast(this.object));
            return arr;
        }
        catch (Exception e) {
            return null;
        }
    }
}

