/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.mapper;

import de.eztxm.ezlib.config.annotation.JsonIgnore;
import de.eztxm.ezlib.config.annotation.JsonValue;
import de.eztxm.ezlib.config.object.JsonArray;
import de.eztxm.ezlib.config.object.JsonObject;
import de.eztxm.ezlib.config.object.JsonUtil;
import de.eztxm.ezlib.config.parse.JsonParser;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JsonMapper {
    public static <T> T fromJson(String json, Class<T> clazz) {
        Object parsed = new JsonParser().parse(json);
        if (!(parsed instanceof JsonObject)) {
            throw new IllegalArgumentException("Expected JSON object");
        }
        JsonObject obj = (JsonObject)parsed;
        try {
            T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : clazz.getDeclaredFields()) {
                Object rawValue;
                Object converted;
                if (field.isAnnotationPresent(JsonIgnore.class)) continue;
                field.setAccessible(true);
                String jsonKey = field.getName();
                if (field.isAnnotationPresent(JsonValue.class)) {
                    jsonKey = field.getAnnotation(JsonValue.class).name();
                }
                if ((converted = JsonMapper.convert(rawValue = obj.get(jsonKey), field.getType())) == null) continue;
                Method setter = JsonMapper.findSetter(clazz, field.getName(), field.getType());
                if (setter != null) {
                    setter.invoke(instance, converted);
                    continue;
                }
                field.setAccessible(true);
                field.set(instance, converted);
            }
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to map JSON to " + clazz.getSimpleName(), e);
        }
    }

    public static String toJson(Object obj) {
        if (obj instanceof JsonObject || obj instanceof JsonArray) {
            return JsonUtil.valueToJson(obj);
        }
        JsonObject json = new JsonObject();
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(JsonIgnore.class)) continue;
            field.setAccessible(true);
            String key = field.getName();
            if (field.isAnnotationPresent(JsonValue.class)) {
                key = field.getAnnotation(JsonValue.class).name();
            }
            try {
                json.put(key, field.get(obj));
            }
            catch (Exception e) {
                throw new RuntimeException("Error accessing field " + field.getName(), e);
            }
        }
        return json.toJsonString();
    }

    private static Method findSetter(Class<?> clazz, String fieldName, Class<?> fieldType) {
        String methodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            return clazz.getMethod(methodName, fieldType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Object convert(Object value, Class<?> targetType) {
        String str;
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return number.intValue();
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return number.longValue();
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (targetType == Double.TYPE || targetType == Double.class) {
                return number.doubleValue();
            }
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                return bool;
            }
        }
        if (value instanceof String) {
            str = (String)value;
            if (targetType == String.class) {
                return str;
            }
        }
        if (value instanceof JsonObject) {
            JsonObject obj = (JsonObject)value;
            if (targetType == JsonObject.class) {
                return obj;
            }
            return JsonMapper.fromJson(obj.toJsonString(), targetType);
        }
        if (value instanceof JsonArray) {
            JsonArray arr = (JsonArray)value;
            if (JsonArray.class.isAssignableFrom(targetType)) {
                return arr;
            }
            if (targetType.isArray()) {
                Class<?> componentType = targetType.getComponentType();
                return JsonMapper.convertArray(arr, componentType);
            }
            if (List.class.isAssignableFrom(targetType)) {
                if (arr.isEmpty()) {
                    return new ArrayList();
                }
                Object first = arr.get(0);
                Class elementType = first != null ? first.getClass() : Object.class;
                return JsonMapper.convertList(arr, elementType);
            }
        }
        if (targetType.isEnum() && value instanceof String) {
            ?[] constants;
            str = (String)value;
            for (Object constant : constants = targetType.getEnumConstants()) {
                if (!((Enum)constant).name().equalsIgnoreCase(str)) continue;
                return constant;
            }
        }
        return null;
    }

    private static Object convertArray(JsonArray<?> jsonArray, Class<?> componentType) {
        int size = jsonArray.size();
        Object array = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Object element = JsonMapper.convert(jsonArray.get(i), componentType);
            Array.set(array, i, element);
        }
        return array;
    }

    private static Object convertList(JsonArray<?> jsonArray, Class<?> elementType) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : jsonArray) {
            if (item instanceof JsonArray) {
                JsonArray innerArray = (JsonArray)item;
                if (elementType == List.class) {
                    list.add(JsonMapper.convertList(innerArray, Object.class));
                    continue;
                }
            }
            Object converted = JsonMapper.convert(item, elementType);
            list.add(converted);
        }
        return list;
    }
}

