/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config.parse;

import de.eztxm.ezlib.config.object.JsonArray;
import de.eztxm.ezlib.config.object.JsonObject;

public class JsonParser {
    private String json;
    private int index;

    public Object parse(String input) {
        this.json = input.trim();
        this.index = 0;
        return this.parseValue();
    }

    private Object parseValue() {
        this.skipWhitespace();
        if (this.index >= this.json.length()) {
            throw new RuntimeException("Unexpected end");
        }
        char ch = this.json.charAt(this.index);
        if (ch == '{') {
            return this.parseObject();
        }
        if (ch == '[') {
            return this.parseArray();
        }
        if (ch == '\"') {
            return this.parseString();
        }
        if (ch == 't' && this.json.startsWith("true", this.index)) {
            this.index += 4;
            return true;
        }
        if (ch == 'f' && this.json.startsWith("false", this.index)) {
            this.index += 5;
            return false;
        }
        if (ch == 'n' && this.json.startsWith("null", this.index)) {
            this.index += 4;
            return null;
        }
        if (ch == '-' || Character.isDigit(ch)) {
            return this.parseNumber();
        }
        throw new RuntimeException("Unexpected character: " + ch);
    }

    private JsonObject parseObject() {
        JsonObject obj;
        block3: {
            char ch;
            obj = new JsonObject();
            ++this.index;
            this.skipWhitespace();
            if (this.json.charAt(this.index) == '}') {
                ++this.index;
                return obj;
            }
            do {
                this.skipWhitespace();
                String key = this.parseString();
                this.skipWhitespace();
                if (this.json.charAt(this.index++) != ':') {
                    throw new RuntimeException("Expected ':'");
                }
                this.skipWhitespace();
                Object value = this.parseValue();
                obj.put(key, value);
                this.skipWhitespace();
                ch = this.json.charAt(this.index++);
                if (ch == '}') break block3;
            } while (ch == ',');
            throw new RuntimeException("Expected ',' or '}'");
        }
        return obj;
    }

    private JsonArray<Object> parseArray() {
        JsonArray<Object> arr;
        block2: {
            char ch;
            arr = new JsonArray<Object>();
            ++this.index;
            this.skipWhitespace();
            if (this.json.charAt(this.index) == ']') {
                ++this.index;
                return arr;
            }
            do {
                this.skipWhitespace();
                arr.add(this.parseValue());
                this.skipWhitespace();
                ch = this.json.charAt(this.index++);
                if (ch == ']') break block2;
            } while (ch == ',');
            throw new RuntimeException("Expected ',' or ']'");
        }
        return arr;
    }

    private String parseString() {
        ++this.index;
        StringBuilder sb = new StringBuilder();
        while (this.json.charAt(this.index) != '\"') {
            char ch;
            if ((ch = this.json.charAt(this.index++)) == '\\') {
                char next = this.json.charAt(this.index++);
                switch (next) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    default: {
                        sb.append(next);
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        ++this.index;
        return sb.toString();
    }

    private Number parseNumber() {
        int start = this.index;
        while (this.index < this.json.length() && "-0123456789.eE".indexOf(this.json.charAt(this.index)) >= 0) {
            ++this.index;
        }
        String num = this.json.substring(start, this.index);
        return num.contains(".") || num.contains("e") || num.contains("E") ? Double.parseDouble(num) : (double)Long.parseLong(num);
    }

    private void skipWhitespace() {
        while (this.index < this.json.length() && Character.isWhitespace(this.json.charAt(this.index))) {
            ++this.index;
        }
    }
}

