/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config;

import de.eztxm.ezlib.api.config.Config;
import de.eztxm.ezlib.config.mapper.JsonMapper;
import de.eztxm.ezlib.config.object.JsonObject;
import de.eztxm.ezlib.config.object.ObjectConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;

public class JsonConfig
implements Config {
    private final Path configFolder;
    private final String configName;
    private final boolean autoSave;
    private JsonObject json;

    public JsonConfig(String path, String configName) {
        this(path, configName, true);
    }

    public JsonConfig(String path, String configName, boolean autoSave) {
        this.configFolder = Paths.get(path, new String[0]);
        this.configName = configName;
        this.autoSave = autoSave;
        try {
            Path file;
            if (Files.notExists(this.configFolder, new LinkOption[0])) {
                Files.createDirectories(this.configFolder, new FileAttribute[0]);
            }
            if (Files.notExists(file = this.configFolder.resolve(configName), new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
                this.json = new JsonObject();
                if (autoSave) {
                    this.save();
                }
                return;
            }
            String raw = Files.readString(file).trim();
            if (raw.isEmpty()) {
                this.json = new JsonObject();
                return;
            }
            try {
                this.json = JsonObject.parse(raw);
            }
            catch (Exception e) {
                this.json = new JsonObject();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Laden der Konfiguration: " + e.getMessage(), e);
        }
    }

    public void set(String key, Object value) {
        this.json.put(key, value);
        if (this.autoSave) {
            this.save();
        }
    }

    public void remove(String key) {
        this.json.remove(key);
        if (this.autoSave) {
            this.save();
        }
    }

    public Object getObject(String key) {
        return this.json.get(key);
    }

    public ObjectConverter get(String key) {
        return new ObjectConverter(this.json.get(key));
    }

    public void addDefault(String key, Object value) {
        if (this.json.containsKey(key)) {
            return;
        }
        this.set(key, value);
    }

    public void save() {
        Path file = this.configFolder.resolve(this.configName);
        try {
            Files.writeString(file, (CharSequence)this.json.toJsonString(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Speichern der Konfiguration: " + e.getMessage(), e);
        }
    }

    public <T> T mapTo(Class<T> clazz) {
        return JsonMapper.fromJson(this.json.toJsonString(), clazz);
    }

    public <T> void mapFrom(T obj) {
        this.json = JsonObject.parse(JsonMapper.toJson(obj));
        if (this.autoSave) {
            this.save();
        }
    }

    @Generated
    public Path getConfigFolder() {
        return this.configFolder;
    }

    @Generated
    public String getConfigName() {
        return this.configName;
    }

    @Generated
    public boolean isAutoSave() {
        return this.autoSave;
    }

    @Generated
    public JsonObject getJson() {
        return this.json;
    }
}

