/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.terminal;

import de.eztxm.logger.LoggerColor;
import de.eztxm.logger.SimpleLogger;
import de.eztxm.terminal.command.CommandMap;
import de.eztxm.terminal.util.JavaColor;
import java.util.Scanner;

public class Terminal {
    private final SimpleLogger logger = new SimpleLogger();
    private final Scanner scanner = new Scanner(System.in);
    private String prompt;
    private String name;
    private CommandMap commandMap;

    public Terminal(String name, String prompt) {
        this.name = name;
        this.prompt = prompt;
        this.commandMap = new CommandMap();
    }

    public Terminal(String name, CommandMap commandMap) {
        this.name = name;
        this.prompt = JavaColor.apply("&9ezLib&8>&7");
        this.commandMap = commandMap;
    }

    public Terminal(String name, String prompt, CommandMap commandMap) {
        this.name = name;
        this.prompt = prompt;
        this.commandMap = commandMap;
    }

    public Terminal(String name) {
        this.name = name;
        this.prompt = JavaColor.apply("&9ezLib &8\u00bb &7");
        this.commandMap = new CommandMap();
    }

    public void start() {
        this.handleTerminal();
    }

    public void writeLine(String prefix, String message) {
        this.logger.custom(JavaColor.apply(prefix + message));
        System.out.flush();
    }

    public void writeLine(String message) {
        this.logger.custom(JavaColor.apply(message));
        System.out.flush();
    }

    public void writeLineColored(String hex, String message) {
        this.logger.custom(JavaColor.colored(hex, message));
        System.out.flush();
    }

    public void writeLineColored(LoggerColor color, String message) {
        this.logger.custom(color, message);
        System.out.flush();
    }

    public void emptyLine() {
        System.out.println("\n");
        System.out.flush();
    }

    public void handleTerminal() {
        Thread thread = new Thread(() -> {
            while (Thread.currentThread().isAlive()) {
                System.out.print(this.prompt);
                if (!this.scanner.hasNext()) continue;
                String rawCommand = this.scanner.nextLine().trim();
                String[] splitRawCommand = rawCommand.split(" ");
                this.commandMap.getCommands().forEach((commandName, command) -> {
                    if (splitRawCommand[0].equalsIgnoreCase((String)commandName)) {
                        splitRawCommand[0] = "";
                        command.execute((String)commandName, splitRawCommand);
                        return;
                    }
                    for (String alias : command.aliases()) {
                        if (!splitRawCommand[0].equalsIgnoreCase(alias)) continue;
                        splitRawCommand[0] = "";
                        command.execute((String)commandName, splitRawCommand);
                        return;
                    }
                });
            }
        }, this.name);
        thread.start();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CommandMap getCommandMap() {
        return this.commandMap;
    }

    public void setCommandMap(CommandMap commandMap) {
        this.commandMap = commandMap;
    }
}

