/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaColor {
    private static final Map<Character, String> colorMap = JavaColor.createColorMap();

    public static String colored(String hex, String message) {
        return JavaColor.hexToAnsi(hex) + message;
    }

    public static String apply(String message) {
        return JavaColor.applyColors(message);
    }

    private static String hexToAnsi(String hexColor) {
        int r = Integer.valueOf(hexColor.substring(1, 3), 16);
        int g = Integer.valueOf(hexColor.substring(3, 5), 16);
        int b = Integer.valueOf(hexColor.substring(5, 7), 16);
        int ansiCode = r / 51 * 36 + g / 51 * 6 + b / 51 + 16;
        return "\u001b[38;5;" + ansiCode + "m";
    }

    private static String applyColors(String input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char colorChar;
            String colorCode;
            char currentChar = input.charAt(i);
            if (currentChar == '&' && i + 1 < input.length() && (colorCode = colorMap.get(Character.valueOf(colorChar = input.charAt(i + 1)))) != null) {
                output.append(colorCode);
                ++i;
                continue;
            }
            output.append(currentChar);
        }
        return output.toString();
    }

    private static Map<Character, String> createColorMap() {
        HashMap<Character, String> colorMap = new HashMap<Character, String>();
        colorMap.put(Character.valueOf('0'), "\u001b[30m");
        colorMap.put(Character.valueOf('1'), "\u001b[34m");
        colorMap.put(Character.valueOf('2'), "\u001b[32m");
        colorMap.put(Character.valueOf('3'), "\u001b[36m");
        colorMap.put(Character.valueOf('4'), "\u001b[31m");
        colorMap.put(Character.valueOf('5'), "\u001b[35m");
        colorMap.put(Character.valueOf('6'), "\u001b[33m");
        colorMap.put(Character.valueOf('7'), "\u001b[37m");
        colorMap.put(Character.valueOf('8'), "\u001b[90m");
        colorMap.put(Character.valueOf('9'), "\u001b[94m");
        colorMap.put(Character.valueOf('a'), "\u001b[92m");
        colorMap.put(Character.valueOf('b'), "\u001b[96m");
        colorMap.put(Character.valueOf('c'), "\u001b[91m");
        colorMap.put(Character.valueOf('d'), "\u001b[95m");
        colorMap.put(Character.valueOf('e'), "\u001b[93m");
        colorMap.put(Character.valueOf('f'), "\u001b[97m");
        colorMap.put(Character.valueOf('r'), "\u001b[0m");
        return colorMap;
    }

    public static String transition(String startHex, String endHex, String message) {
        int transitionSteps = message.length();
        List<String> transitionColors = JavaColor.generateTransitionColors(startHex, endHex, transitionSteps);
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            String colorCode = transitionColors.get(i);
            output.append(colorCode).append(message.charAt(i));
        }
        return output.toString();
    }

    public static String ansiTransition(String startAnsi, String endAnsi, String message) {
        int transitionSteps = message.length();
        List<String> transitionColors = JavaColor.generateAnsiTransitionColors(startAnsi, endAnsi, transitionSteps);
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            String colorCode = transitionColors.get(i);
            output.append(colorCode).append(message.charAt(i));
        }
        return output.toString();
    }

    private static List<String> generateTransitionColors(String startHex, String endHex, int steps) {
        int startR = Integer.valueOf(startHex.substring(1, 3), 16);
        int startG = Integer.valueOf(startHex.substring(3, 5), 16);
        int startB = Integer.valueOf(startHex.substring(5, 7), 16);
        int endR = Integer.valueOf(endHex.substring(1, 3), 16);
        int endG = Integer.valueOf(endHex.substring(3, 5), 16);
        int endB = Integer.valueOf(endHex.substring(5, 7), 16);
        ArrayList<String> transitionColors = new ArrayList<String>();
        for (int i = 0; i < steps; ++i) {
            int currentR = JavaColor.interpolate(startR, endR, i, steps);
            int currentG = JavaColor.interpolate(startG, endG, i, steps);
            int currentB = JavaColor.interpolate(startB, endB, i, steps);
            int ansiCode = currentR / 51 * 36 + currentG / 51 * 6 + currentB / 51 + 16;
            String colorCode = "\u001b[38;5;" + ansiCode + "m";
            transitionColors.add(colorCode);
        }
        return transitionColors;
    }

    private static int interpolate(int start, int end, int currentStep, int totalSteps) {
        float ratio = (float)currentStep / (float)totalSteps;
        return (int)((float)start + (float)(end - start) * ratio);
    }

    private static List<String> generateAnsiTransitionColors(String startAnsi, String endAnsi, int steps) {
        int startCode = JavaColor.extractAnsiCode(startAnsi);
        int endCode = JavaColor.extractAnsiCode(endAnsi);
        ArrayList<String> transitionColors = new ArrayList<String>();
        for (int i = 0; i < steps; ++i) {
            int currentCode = JavaColor.interpolate(startCode, endCode, i, steps);
            String colorCode = "\u001b[" + currentCode + "m";
            transitionColors.add(colorCode);
        }
        return transitionColors;
    }

    private static int extractAnsiCode(String ansiColor) {
        String codeString = ansiColor.substring(ansiColor.indexOf(91) + 1, ansiColor.indexOf(109));
        return Integer.parseInt(codeString);
    }
}

