/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm;

import de.eztxm.command.CommandMap;
import de.eztxm.utils.JavaColor;
import java.util.Scanner;

public class Terminal {
    private Scanner scanner = new Scanner(System.in);
    private String prompt;
    private CommandMap commandMap;

    public Terminal(String prompt) {
        this.prompt = prompt;
        this.commandMap = new CommandMap();
    }

    public Terminal(CommandMap commandMap) {
        this.prompt = JavaColor.apply("&9ezLib&8>&7");
        this.commandMap = commandMap;
    }

    public Terminal(String prompt, CommandMap commandMap) {
        this.prompt = prompt;
        this.commandMap = commandMap;
    }

    public Terminal() {
        this.prompt = JavaColor.apply("&9ezLib&8>&7");
        this.commandMap = new CommandMap();
    }

    public void start() {
        this.handleTerminal();
    }

    public void handleTerminal() {
        Thread commandThread = new Thread(() -> {
            while (Thread.currentThread().isAlive()) {
                System.out.print(this.prompt);
                if (!this.scanner.hasNext()) continue;
                String rawCommand = this.scanner.nextLine();
                String[] splitRawCommand = rawCommand.split(" ");
                this.commandMap.getCommands().forEach((commandName, command) -> {
                    if (splitRawCommand[0].equalsIgnoreCase((String)commandName)) {
                        splitRawCommand[0] = "";
                        command.execute((String)commandName, splitRawCommand);
                        return;
                    }
                    for (String alias : command.aliases()) {
                        if (!splitRawCommand[0].equalsIgnoreCase(alias)) continue;
                        splitRawCommand[0] = "";
                        command.execute((String)commandName, splitRawCommand);
                        return;
                    }
                });
            }
        });
        commandThread.start();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public CommandMap getCommandMap() {
        return this.commandMap;
    }

    public void setCommandMap(CommandMap commandMap) {
        this.commandMap = commandMap;
    }
}

