/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.downloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Downloader {
    public static void downloadFile(String fileURL, String saveDir) throws IOException {
        URL url = new URL(fileURL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String fileName = "";
            String disposition = connection.getHeaderField("Content-Disposition");
            if (disposition != null) {
                int index = disposition.indexOf("filename=");
                if (index > 0) {
                    fileName = disposition.substring(index + 10, disposition.length() - 1);
                }
            } else {
                fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1);
            }
            InputStream inputStream = connection.getInputStream();
            String saveFilePath = saveDir + "/" + fileName;
            Path savePath = Paths.get(saveFilePath, new String[0]);
            Files.copy(inputStream, savePath, new CopyOption[0]);
            inputStream.close();
            System.out.println("File downloaded to " + saveFilePath);
        } else {
            System.out.println("No file to download. Server replied HTTP code: " + responseCode);
        }
        connection.disconnect();
    }
}

