/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.database;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDBConnection {
    private final MongoDatabase mongoDatabase;

    public MongoDBConnection(String host, int port, String username, String password, String database) {
        String uri = "mongodb://" + username + ":" + password + "@" + host + ":" + port + "/?authSource=" + database;
        MongoClient mongoClient = MongoClients.create((String)uri);
        this.mongoDatabase = mongoClient.getDatabase(database);
    }

    public boolean createCollection(String collection) {
        if (!this.isCollectionExists(collection)) {
            return false;
        }
        this.mongoDatabase.createCollection(collection);
        return true;
    }

    public boolean isCollectionExists(String collection) {
        boolean exists = false;
        for (String collectionName : this.mongoDatabase.listCollectionNames()) {
            if (!collectionName.equals(collection)) continue;
            exists = true;
        }
        return exists;
    }

    public MongoCollection<Document> getCollection(String name) {
        return this.mongoDatabase.getCollection(name);
    }

    public Document find(String collection, Bson filter) {
        return (Document)this.getCollection(collection).find(filter).first();
    }

    public FindIterable<Document> findMultiple(String collection, Bson filter) {
        return this.getCollection(collection).find(filter);
    }

    public void insert(String collection, Document insert) {
        this.getCollection(collection).insertOne((Object)insert);
    }

    public void update(String collection, Bson filter, Document update) {
        this.getCollection(collection).updateOne(filter, (Bson)update);
    }

    public void replace(String collection, Bson filter, Document update) {
        this.getCollection(collection).replaceOne(filter, (Object)update);
    }

    public void delete(String collection, Bson filter) {
        this.getCollection(collection).deleteOne(filter);
    }
}

