/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config;

import de.eztxm.ezlib.api.config.Config;
import de.eztxm.ezlib.config.object.JsonObject;
import de.eztxm.ezlib.config.object.ObjectConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonConfig
implements Config {
    private final String configPath;
    private final String configName;
    private final JSONObject jsonObject;

    public JsonConfig(String path, String configName) {
        this.configPath = path;
        this.configName = configName;
        File folder = new File(path);
        File configFile = new File(path + "/" + this.configName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                this.jsonObject = new JSONObject();
                this.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        String configJson = this.readFile(path + "/" + this.configName);
        this.jsonObject = new JSONObject(configJson);
    }

    public void set(String key, Object value) {
        this.jsonObject.put(key, value);
        this.save();
    }

    public void remove(String key) {
        this.jsonObject.remove(key);
        this.save();
    }

    public ObjectConverter get(String key) {
        try {
            Object object = this.jsonObject.get(key);
            return new ObjectConverter(object);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void addDefault(String key, Object value) {
        if (this.get(key) != null) {
            return;
        }
        this.set(key, value);
    }

    public JsonObject toJsonObject() {
        return new JsonObject(this.jsonObject);
    }

    public void save() {
        try (FileWriter file = new FileWriter(this.configPath + "/" + this.configName);){
            file.write(this.jsonObject.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readFile(String filePath) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringBuilder.toString();
    }
}

