/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.ezlib.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.eztxm.ezlib.api.config.Config;
import de.eztxm.ezlib.object.ObjectConverter;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class YamlConfig
implements Config {
    private final YAMLMapper yamlMapper;
    private final File configFile;

    public YamlConfig(String path, String configName) {
        File folder = new File(path);
        this.configFile = new File(path + "/" + configName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
                this.yamlMapper = new YAMLMapper();
                this.yamlMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        this.yamlMapper = new YAMLMapper();
    }

    public void set(String key, Object value) {
        try {
            Map map = (Map)this.yamlMapper.readValue(this.configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            map.put(key, value);
            this.yamlMapper.writeValue(this.configFile, (Object)map);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    public void remove(String key) {
        try {
            Map map = (Map)this.yamlMapper.readValue(this.configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            map.remove(key);
            this.yamlMapper.writeValue(this.configFile, (Object)map);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    public ObjectConverter getObject(String key) {
        try {
            Map map = (Map)this.yamlMapper.readValue(this.configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Object value = map.get(key);
            return new ObjectConverter(value);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Object getAsObject(String key) {
        try {
            Map map = (Map)this.yamlMapper.readValue(this.configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map.get(key);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void addDefault(String key, Object value) {
        if (this.getObject(key) != null) {
            return;
        }
        this.set(key, value);
    }
}

