/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.nexonet.packet.crypto;

import com.nexoscript.nexonet.api.crypto.CryptoType;
import com.nexoscript.nexonet.api.crypto.ICryptoManager;
import com.nexoscript.nexonet.api.crypto.KeySize;
import com.nexoscript.nexonet.logger.LoggingType;
import com.nexoscript.nexonet.logger.NexonetLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptoManager
implements ICryptoManager {
    private NexonetLogger logger;
    private SecretKey secretKey;
    private Cipher cipher;

    public CryptoManager(NexonetLogger logger) {
        this.logger = logger;
    }

    public void initCrypto(String path, CryptoType type, KeySize size) {
        try {
            this.logger.log(LoggingType.INFO, "Try to parse SecretFile!");
            File secretFile = new File(path);
            if (!secretFile.exists()) {
                this.logger.log(LoggingType.INFO, "SecretFile don't exists");
                KeyGenerator keyGenerator = KeyGenerator.getInstance(type.key());
                keyGenerator.init(size.size());
                this.secretKey = keyGenerator.generateKey();
                Files.createFile(Path.of(secretFile.toURI()), new FileAttribute[0]);
                Files.write(secretFile.toPath(), Base64.getEncoder().encodeToString(this.secretKey.getEncoded()).getBytes(), new OpenOption[0]);
                this.cipher = Cipher.getInstance(type.key());
                this.logger.log(LoggingType.INFO, "created new Secret File with Token");
                return;
            }
            this.logger.log(LoggingType.INFO, "Try to Parse Secret Key from File");
            byte[] encodedKey = Files.readAllBytes(Paths.get(path, new String[0]));
            String keyString = new String(encodedKey);
            byte[] decodedKey = Base64.getDecoder().decode(keyString);
            this.secretKey = new SecretKeySpec(decodedKey, type.key());
            this.cipher = Cipher.getInstance(type.key());
            this.logger.log(LoggingType.INFO, "Secret Key parsed, Cipher initialized!");
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public String encryptString(String data) {
        try {
            this.logger.log(LoggingType.INFO, "Try to encode String");
            this.cipher.init(1, this.secretKey);
            return Base64.getEncoder().encodeToString(this.cipher.doFinal(data.getBytes()));
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public String decryptString(String data) {
        try {
            this.logger.log(LoggingType.INFO, "Try to decode String");
            this.cipher.init(2, this.secretKey);
            return new String(this.cipher.doFinal(Base64.getDecoder().decode(data.getBytes())));
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }
}

