/*
 * Decompiled with CFR 0.152.
 */
package com.nexoscript.nexonet.server;

import com.nexoscript.nexonet.api.networking.IClientHandler;
import com.nexoscript.nexonet.api.networking.IServer;
import com.nexoscript.nexonet.api.packet.IPacketManager;
import com.nexoscript.nexonet.api.packet.Packet;
import com.nexoscript.nexonet.logger.LoggingType;
import com.nexoscript.nexonet.packet.impl.AuthPacket;
import com.nexoscript.nexonet.packet.impl.AuthResponsePacket;
import com.nexoscript.nexonet.packet.impl.DisconnectPacket;
import com.nexoscript.nexonet.server.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;

public class ClientHandler
implements Runnable,
IClientHandler {
    private final IServer server;
    private final Socket clientSocket;
    private String id;
    private boolean isAuth = false;
    private BufferedReader reader;
    private PrintWriter writer;
    private IPacketManager packetManager;

    public ClientHandler(Socket socket, Server server, IPacketManager packetManager) {
        this.clientSocket = socket;
        this.server = server;
        this.packetManager = packetManager;
    }

    public String getId() {
        return this.id;
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    public boolean isAuth() {
        return this.isAuth;
    }

    public void setAuth(boolean auth) {
        this.isAuth = auth;
    }

    public IServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            try {
                String clientMessage;
                InputStream input = this.clientSocket.getInputStream();
                OutputStream output = this.clientSocket.getOutputStream();
                this.reader = new BufferedReader(new InputStreamReader(input));
                this.writer = new PrintWriter(output, true);
                if (!this.clientSocket.isConnected()) break block15;
                while ((clientMessage = this.reader.readLine()) != null) {
                    System.out.println(clientMessage);
                    Packet packet = this.packetManager.fromJson(clientMessage);
                    if (packet instanceof DisconnectPacket) {
                        DisconnectPacket disconnectPacket = (DisconnectPacket)packet;
                        this.server.getLogger().log(LoggingType.INFO, "Client disconnected. Code: " + disconnectPacket.getCode());
                        this.server.getClients().remove(this);
                        this.isAuth = false;
                        this.server.getClientDisconnectEvent().onClientDisconnect((IClientHandler)this);
                        break;
                    }
                    if (!this.isAuth) {
                        if (packet instanceof AuthPacket) {
                            AuthPacket authPacket = (AuthPacket)packet;
                            this.id = authPacket.getId();
                            this.isAuth = true;
                            this.server.getClients().add(this);
                            this.server.sendToClient(this.id, (Packet)new AuthResponsePacket(true, this.id));
                            this.server.getClientConnectEvent().onClientConnect((IClientHandler)this);
                            continue;
                        }
                        this.server.sendToClient(this.id, (Packet)new AuthResponsePacket(false, this.id));
                        continue;
                    }
                    this.server.getServerReceivedEvent().onServerReceived((IClientHandler)this, packet);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.clientSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }
}

